figure1 = figure('Color',[1 1 1],'rend','painters','pos',[10 10 500 600]);
set(gca,'FontSize',8);
set(gca,'color','none')
x1 = cell2mat(dsc120(1:end,2));
x2 = cell2mat(dsc150(1:end,2));
x3 = cell2mat(dsc1100(1:end,2));


y1 = cell2mat(dsc120(1:end,3));
y2 = cell2mat(dsc150(1:end,3));
y3 = cell2mat(dsc1100(1:end,3));

y1a = y1/6.6;
y2a = y2/5.9;
y3a = y3/5.9;

%top - 1/20
subfig1 = subplot(3,1,1);
plot(x1,y1a,'LineWidth',0.75,'Color',[0.3020    0.7490    0.9294]);
set(gca,'FontSize',8);
ylim([-0.5 0.5]);
xlim([-20 105]);
xlabel('Temperature (C)');
ylabel('HeatFlow ,mW/mg)');
s1t = title('ensilicated lysozyme 1:20');
subfig2 = subplot(3,1,2);
%mid - 1/50
plot(x2,y2a,'LineWidth',0.75,'Color',[0    0.55    0.8]);
set(gca,'FontSize',8);
ylim([-0.5 0.5]);
xlim([-20 105]);
xlabel('Temperature (C)');
ylabel('HeatFlow ,mW/mg)');
s1t = title('ensilicated lysozyme 1:50');
subfig3 = subplot(3,1,3);
% bot - 1/100
plot(x3,y3a,'LineWidth',0.75,'Color',[  0    0.3490    0.7412]);
set(gca,'FontSize',8);
ylim([-0.5 0.5]);
xlim([-20 105]);
s1t = title('ensilicated lysozyme 1:100');
% legend({'1:20','1:50','1:100'},'Location','northeastoutside');
xlabel('Temperature (C)');
ylabel('HeatFlow ,mW/mg)');
% ylim([-3 7]);
% xlim([-15 105]);

set(subfig1,'FontSize',8);
set(subfig2,'FontSize',8);
set(subfig3,'FontSize',8);

% Create textarrow
an1 = annotation(figure1,'textarrow',[0.155 0.155],...
    [0.75 0.90],'String',{'exo'});

% Create textarrow
an2 = annotation(figure1,'textarrow',[0.155 0.155],...
    [0.45 0.6],'String',{'exo'});

% Create textarrow
an3 = annotation(figure1,'textarrow',[0.155 0.155],...
    [0.15 0.3],'String',{'exo'});

an1.FontSize = 8;
an2.FontSize = 8;
an3.FontSize = 8;